\version "2.24.0"
\language "deutsch"

\paper {
  markup-system-spacing = #'((basic-distance . 12))
  system-system-spacing = #'((basic-distance . 16))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 8\mm
  ragged-last-bottom=##f
  system-count = #4
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Joy to the world"
  %subtitle = "Adeste fideles"
  %subsubtitle = "Nr. 9, Choral"
  poet = "Isaac Watts (1674–1748)"
  composer = \markup \center-column { "Lowell Mason" 
  \small "(G. F. Händel - The Messiah)" }
  %arranger =  "arr. W.H.Monk(1823-1886)"
  %meter = "Andante"
  tagline = ""
}

global = {
  %#(set-global-staff-size 18.5)
  \key d \major
  \time 2/2
  %\partial 4
  %\override Staff.TimeSignature.stencil = ##f
  %\set Timing.measureBarType = ""
  %\set Score.barNumberVisibility = ##f
  \set Staff.midiInstrument = "clarinet"
  \autoBeamOn
}


sopWordsOne = \lyricmode {
  \skip 1 \skip 1  \skip 1 \skip 1
  the Lord is come!
  Let earth re -- ceive her King! __  
}

sopWordsOne = \lyricmode {
  \set stanza = "1."
  Joy to the world, the Lord is come!
  Let earth re -- ceive her King! __
  Let ev -- 'ry __ heart __ pre -- pare __ Him __ room, __
  And heav'n and na -- ture sing,
  and heav'n and na -- ture sing,
  and heav'n and  heav'n __ and na -- ture sing! sing!
}  

sopWordsTwo = \lyricmode {
  \set stanza = "2."
  Joy to the earth, the Sa -- vior reigns:
  Let men their songs em -- ploy! __
  While fields and __ floods, __ rocks, hills __ and __ plains __
  Re -- peat the soun -- ding joy,
  re -- peat the soun -- ding joy,
  re -- peat, re -- peat __ the soun -- ding joy. joy.
}

sopWordsFour = \lyricmode {
  \set stanza = "4."
  He rules the world with truth and grace,
  And makes the na -- tions prove, __
  The glo -- ries __ of __ His right -- eous -- ness, __
  And won -- ders of His love,
  and won -- ders of His love,
  and won -- ders, won -- ders of His love. love.
}


bassWordsOne = \lyricmode {
  \set stanza = "1."
  Joy to the world, __ the Lord is come!
  Let earth re -- ceive her King,  re -- ceive her King,
  Let ev -- 'ry heart pre -- pare __ Him __ room,
  And heav'n and na -- ture sing,
  and heav'n and na -- ture sing, __
  and heav'n and na -- ture sing! sing!
}

bassWordsTwo = \lyricmode {
  \set stanza = "2."
  Joy to the earth, __ the Sa -- vior reigns:
  Let men their songs em -- ploy, their songs em -- ploy! 
  While fields and floods, rocks, hills __ and __ plains
  Re -- peat the soun -- ding joy,
  re -- peat the soun -- ding joy, __
  re -- peat the soun -- ding joy! joy!
}

bassWordsFour = \lyricmode {
  \set stanza = "4."
  He rules the world __ with truth and grace,
  And makes the na -- tions prove, the na -- tions prove, 
 The glo -- ries of His right -- eous -- ness,
  And won -- ders of His love,
  and won -- ders of His love, __
  and won -- ders of His love. love.  
}

sopMusic = \relative c'' {
  d2 cis4. h8 a2. g4 fis2 e d2. a'4 h2. 
  h4  cis2.  cis4 d1( d2.) d4 ^\markup [SOLI]
  d4( cis) h( a) a4.( g8 fis4) d' d( cis) h( a) a4.( g8 fis4) \fermata
  \repeat volta 2 {
   fis4 ^\markup [FULL]
   fis fis fis fis a2. g8([ fis]) e4 e e e g2. fis8([ e])
   d4( d'2) h4 a4.( g8 fis4) g fis2 e   
  }
  \alternative {
   { d2. s4 }
   { d1 }
  }
  \bar"|."
}

bassMusic = \relative c {
  d2 e4. e8 fis4.( e8 d4) h a2 a d2. d4
  g2. e4 a2. fis4 h4. a8 g([ a]) h([ cis]) d2. d,4
  d2 d d2. d4 fis8[( d e fis]) g([ a h cis]) d2.
  \repeat volta 2 {
   d,4\rest d2\rest d4\rest d4 fis fis fis fis a2. g8([ fis]) e4 e e e
   fis4.( e8 d4) d d2. h4 a2 a
  } 
  \alternative {
   { d2. s4 }
   { d1 }
  } 
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \global \sopMusic }
      %\new Voice { \voiceTwo \global \altMusic }
      \addlyrics \sopWordsOne
      \addlyrics \sopWordsTwo
      \addlyrics \sopWordsFour
     >>

    \new Staff <<
      \clef bass
      %\new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \global \bassMusic }
      \addlyrics { \bassWordsOne }
      \addlyrics { \bassWordsTwo }
      \addlyrics { \bassWordsFour }
    >>
  >>
>>


\score {
   \myScore
   \layout { }
}

midiOutput = \midi {
    \tempo 4 = 80
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}